/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations.components;

import java.util.Locale;
import net.impactdev.impactor.api.platform.audience.LocalizedAudience;
import net.impactdev.impactor.api.translations.TranslationManager;
import net.impactdev.impactor.api.translations.TranslationProvider;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.core.translations.ImpactorTranslationManager;
import net.impactdev.impactor.core.translations.components.Translation;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

public class ImpactorTranslationProvider<T>
implements TranslationProvider<T> {
    private final TranslationManager manager;
    private final String key;

    public ImpactorTranslationProvider(TranslationManager manager, String key) {
        this.manager = manager;
        this.key = key;
    }

    @Override
    @NotNull
    public T resolve(@NotNull Locale locale, @NotNull Context context) {
        return this.translation(locale).build(this.manager.processor(), context);
    }

    @Override
    public void send(@NotNull Audience audience, @NotNull Context context) {
        Translation<T> resolved;
        Locale target = this.manager.defaultLocale();
        if (audience instanceof LocalizedAudience) {
            target = ((LocalizedAudience)audience).locale();
        }
        if ((resolved = this.translation(target)) == null) {
            audience.sendMessage(((TextComponent)Component.text((String)"Invalid translation: ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)this.key).color((TextColor)NamedTextColor.RED)));
            return;
        }
        resolved.send(audience, this.manager.processor(), context);
    }

    private Translation<T> translation(@NotNull Locale locale) {
        return ((ImpactorTranslationManager)this.manager).fetch(locale).translation(this.key);
    }

    public static class TranslationProviderFactory
    implements TranslationProvider.Factory {
        @Override
        public <T> TranslationProvider<T> create(@NotNull TranslationManager manager, @NotNull String key) {
            return new ImpactorTranslationProvider(manager, key);
        }
    }
}

